% Function: This is function that formats the experimental data into the
% desired matrix format (when using 2 plates), this is done independently
% for each replicate

% Inputs:
% Plate(1/2)Cell - A cell from MultiPlexAnlys_XMLImport that contains the
%    unformatted data
% ProbeWell_(1/2) - A list that specifies the well number for each of the
%    probes, in the order to match the list with the probe names
% BeadRegions - A list with the all the IP bead regions used
% ShiftList_(1/2) - A list that that rearranges the data from the xml order
%    to a desired format for display figures 

% Outputs:
% MatrixOutput - This exports the median value for each of the ip/probe
%    combinations, formatted as a matrix 
% CellOutput - A cell array, where each entry has all the bead fluorescent
%    values for a given ip/probe, again formatted in as a matrix 

function [MatrixOutput, CellOutput] = MultiPlexMatrixCold(Plate1Cell,...
Plate2Cell,ProbeWell_1,ProbeWell_2,BeadRegions,ShiftList_1,ShiftList_2)

Probes_N1 = length(ProbeWell_1);
Probes_N2 = length(ProbeWell_2);
Probe_N = Probes_N1+Probes_N2;
Bead_N = length(BeadRegions);

MatrixOutput = zeros(Probe_N,Bead_N);
CellOutput = cell(Probe_N,Bead_N);

for Bead_i = 1:Bead_N
    
    for alpha = 1:Probes_N1
        
        IndexOfWell_1 = ProbeWell_1(alpha);
        CellIndex_1 = (IndexOfWell_1-1)*Bead_N + Bead_i;
        
        ShiftPos_1 = ShiftList_1(alpha);
        
        CellOutput{ShiftPos_1,Bead_i} = Plate1Cell{CellIndex_1};
        MatrixOutput(ShiftPos_1,Bead_i) = median(Plate1Cell{CellIndex_1});
        
    end
    
    for beta = 1:Probes_N2
        
        IndexOfWell_2 = ProbeWell_2(beta);
        CellIndex_2 = (IndexOfWell_2-1)*Bead_N + Bead_i;
        
        ShiftPos_2 = ShiftList_2(beta);

        CellOutput{ShiftPos_2,Bead_i} = Plate2Cell{CellIndex_2};
        MatrixOutput(ShiftPos_2,Bead_i) = median(Plate2Cell{CellIndex_2});
        
    end
end